<?php
	//---------------------------
	//VARIABLES
	//---------------------------
	$json_file_version = 1;				//version of gallery text in json format.
	$viniviewer_version = "0.2";		//soft version
	
	$folder_images = "images";			//folder for images
	$folder_thumbnails = "thumbnails";	//folder for thumbnails
	
	$json_file = "gallery.js";			//JSON file containing img data: location, size, comment, etc...
	$json_folder_file = "folder.js";	//JSON file containing folder scanned
	$config_file = "config.php";		//configuration file

	//theme and styles
	//$theme_path = "themes/default/";
	//$css_path = $theme_path."css/galerie.css";

	//taille des miniatures (carr).
	$thb_size = 71; 

	//tables for images and folder
	$images = array();
	$folders = array();
	
	//filtre des formats d'images affiches
	$filtre_format_img = array("jpg", "gif", "png");

	//language proposed for translation. (flag available in default/image).
	//code = http://www.w3schools.com/tags/ref_language_codes.asp
	$GLOBALS['TRANSLATION_SUPPORTED'] = "fr en es it de sn";
	$GLOBALS['CURRENT_PAGE'] = basename($_SERVER["SCRIPT_NAME"]);
	//---------------------------------------------------------

	//default parameters. can be change through admin panel
	$GLOBALS['PARAMETERS']['gal_name'] = "VINIVIEWER";
	$GLOBALS['PARAMETERS']['delay_diapo'] = 3000;
	$GLOBALS['PARAMETERS']['allow_exif'] = 1;
	$GLOBALS['PARAMETERS']['language'] = "en";
	$GLOBALS['PARAMETERS']['sort_option'] = "dorigin_date";
	$GLOBALS['PARAMETERS']['theme'] = "default";
	
	//SESSION START
	if (!ISSET($_SESSION)) session_start();  //ne charge session que si elle n'existe pas

	//auto detect user language
	$auto_lg = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 2);
	foreach(explode(" ", $GLOBALS['TRANSLATION_SUPPORTED']) as $key => $value){
		//if language translation is supported
		if($auto_lg == $value){$_SESSION["language"] = $auto_lg;}
	}
	
	//---------------------------------------------------------
	//LOAD USER CONFIGURATION
	//---------------------------------------------------------
	//fichier config n'existe pas => installation
	If (!file_exists($config_file)) {
		$_SESSION["install_cfg"] = true;
	}
	//on rcupre le fichier config
	else{
		include_once $config_file;
	
		//loading users configurations into global variables
		if(ISSET($CONFIG["gal_name"])){$GLOBALS['PARAMETERS']['gal_name'] = $CONFIG["gal_name"];}
		if(ISSET($CONFIG["delay_diapo"])){$GLOBALS['PARAMETERS']['delay_diapo'] = $CONFIG["delay_diapo"];}
		if(ISSET($CONFIG["allow_exif"])){$GLOBALS['PARAMETERS']['allow_exif'] = $CONFIG["allow_exif"];}
		if(ISSET($CONFIG["sort_option"])){$GLOBALS['PARAMETERS']['sort_option'] = $CONFIG["sort_option"];}
		if(ISSET($CONFIG["language"])){$GLOBALS['PARAMETERS']['language'] = $CONFIG["language"];}
		if(ISSET($CONFIG["theme"])){$GLOBALS['PARAMETERS']['theme'] = $CONFIG["theme"];}
		
		//on vrifie la version du fichier json de la galerie
		if(ISSET($CONFIG["current_json_file_version"])){
			$current_json_file_version = $CONFIG["current_json_file_version"];
			
			if($current_json_file_version != $json_file_version){
				echo "debug : JSON file for galerie need a update.";
				exit;
			}
		}
	}
	//---------------------------------------------------------
	
	//---------------------------------------------------------
	//translation
	//---------------------------------------------------------
	//check language session: user can used a different language than language defined in config file by the admin.
	if(ISSET($_SESSION["language"]) && $GLOBALS['CURRENT_PAGE'] != "admin.php"){
		$GLOBALS['PARAMETERS']['language'] = $_SESSION["language"];
	}
	$language_file_path = "language/translation_".$GLOBALS['PARAMETERS']['language'].".js";
	$lg_file_content = file_get_contents($language_file_path);
	
	//decode the file in a table
	$GLOBALS['TRANSLATION'] = json_decode($lg_file_content, true);
	
	//if language file is not readable
	if(!is_array($GLOBALS['TRANSLATION'])){
		echo "impossible to read translation file: $language_file_path. Default language (EN) used instead.";
		
		//loading default language
		$lg_file_content = file_get_contents("language/translation_EN.js");
		
		//decode the file in a table
		$GLOBALS['TRANSLATION'] = json_decode($lg_file_content, true) or die ("impossible to read the default langage file (EN)");
	}
	
	
	//---------------------------------------------------------
	//common functions
	//---------------------------------------------------------
	
	//translate all terms in the selected language
	function translate($page, $ad_element = null, $loop = null){
		$VAR_TP = array();
		$VAR_CODE = array();
		
		foreach($GLOBALS['TRANSLATION'] as $key => $value){
			$VAR_TP[] = "{".$key."}"; 
			$VAR_CODE[] = "$value"; 
		}
		
		//add another translation, on variable for example
		if($ad_element != null && is_array($ad_element)){
			foreach($ad_element as $key => $value){
				$VAR_TP[] = $key; 
				$VAR_CODE[] = "$value"; 
			}
		}
		
		//generic replacement
		$VAR_TP[] = "{theme_path}"; $VAR_CODE[] = "themes/".$GLOBALS['PARAMETERS']['theme']; 
		$VAR_TP[] = "{css}"; $VAR_CODE[] = "themes/".$GLOBALS['PARAMETERS']['theme']."/css/galerie.css"; 
		
		//insertion des messages dans la page  afficher
		$page_tr = str_replace($VAR_TP, $VAR_CODE, $page);
		
		//if loop requested, we redo a translation.
		//used when $ad_element introduce text to translate...
		if($loop == 1){
			$page_tr = str_replace($VAR_TP, $VAR_CODE, $page_tr);
		}
		
		return $page_tr;
	}
	
	//objet contenu toutes les infos des images
	class ObjImage {
		//attributs
		public $filename;
		public $folder;
		public $text;
		public $date_img;
		public $width;
		public $height;
		public $position;
		public $hide;
		public $exif = array();
		
		//method to return a "readable" date
		public function date_img_formated() {
			return date ("Y-m-d H:i", $this->date_img);
		}
		
		//method to clean the comment before integration
		public function text_in($com) {
			
			//if magic_quotes_gpc is activated, we remove slashes added
			if (get_magic_quotes_gpc()) {
				$com = stripslashes($com);
			}
			$this->text = $com;
		}
		
		//method to clean the comment before exportation
		public function text_out($code = null, $br = null) {
			$code_out = $this->text;
			
			//manage line return for html display
			if ($br == 'nl2br'){
				$code_out = nl2br($code_out);
			}
			//handle newlines before injection in Javascript code
			if ($code == 'java'){
				$code_out = json_encode($code_out);
			}
			return $code_out;
		}
		
		//methode to return the path of the img
		public function path() {
			return $this->folder."/".$this->filename;
		}
		
		//method for exif presentation
		public function show_EXIF() {
			$text_exif = "";
			foreach($this->exif as $exif_title => $exif_value){
				if($exif_value !=NULL || $exif_value !=""){
					$text_exif .= "<b>$exif_title :</b> $exif_value<br/>";
				}
			}
			return $text_exif;
		}
		
		//method to convert value from a $data table into attributs 
		public function set($data) {
			foreach ($data as $key => $value) {
				$this->{$key} = $value;
			}
		}
	}
	
	class ObjFolder{
		public $foldername;
		public $folderpath;
		public $hide;
	}
		
	//cette fonction lit le fichier JSON et l'extrait dans un objet image.
	function read_json(){
		
		//on rcupre les variables globales ncessaires
		global $images, $json_file;
		
		//if $images table is empty (json not already readed)
		if(empty($images)){
			if (!file_exists($json_file)){header('Location: index.php');}
			
			//on affecte le contenu du fichier  la variable JSON_file
			$json_file_content = file_get_contents($json_file);

			//on dcode les objets des images dans le tableau ( ,true)
			$tmp = json_decode($json_file_content, true);
			
			//convert each table key into an object, and we transfert attributs thanks to the 'set' function
			foreach($tmp as $key => $table){
				$images[$key] = new ObjImage();
				$images[$key]->set($table);
			}
		}
	}

	//mise  jour du fichier config
	function update_config(){
		//on rcupre les variables globales ncessaires
		global $CONFIG, $config_file;
		
		$text = "<?php\n\$CONFIG=".var_export($CONFIG,true).";\n?>";
				
		//on enregistre les infos dans le fichier config
		file_put_contents($config_file, $text);
	}
	
	//display list of language available 
	function list_lang(){
		$tab = explode(" ", $GLOBALS['TRANSLATION_SUPPORTED']);
		
		$code = "<ul id='country'>\n";		
		foreach($tab as $key =>$country){
			//if language file exist
			$lang_file = "language/translation_$country.js";
			If (file_exists($lang_file)) {
				$li_class= $country;
				$link = $GLOBALS['CURRENT_PAGE']."?L=$country";
				$action = "";
			}
			//we shade the flag on display
			else{
				$li_class = "s".$country;
				$link = "#";
				$action = "alert(\"Language file not available.\\nUpload the file translation_{$country}.js into the language folder to activate the translation.\");";
			}
			
			//for current language selected 
			if ($GLOBALS['PARAMETERS']['language'] == $country){$a_class= "slct";}
			else{$a_class = "";}
			
			$code .= "
			<li class='$li_class'>
			<a href='$link' alt='$country' title='$country' class='$a_class' onclick='$action'></a>
			</li>\n";
		}
		$code .= "</ul>";
		return $code;
	}
	
?>