<?php
	//integration of init file
	include_once('init_data.php');

	//language change
	if(ISSET($_GET['L'])){
		$tab = explode(" ", $GLOBALS['TRANSLATION_SUPPORTED']);
		
		//if language proposed is supported
		foreach($tab as $key =>$country){
			if($_GET['L'] == $country){
				//set the new language session. used only for viewer (not admin)
				$_SESSION["language"] = $country;
				break;
			}
		}
		header('Location: login.php');
	}
	
	/*login protection.
	sources: http://sebsauvage.net/paste/?36dbd6c6be607e0c#M5uR8ixXo5rXBpXx32gOATLraHPffhBJEeqiDl1dMhs=
	Instructions d'utilisation:
	  Faites un require_once de ce script.
	   l'endroit o vous testez la validit du mot de passe:
		  Si ban_canLogin()==false, l'utilisateur est banni. Ne testez mme pas le mot de passe: Rejetez l'utilisateur.
		  Si ban_canLogin()==true, vrifiez le mot de passe.
			    Si le mot de passe est ok, appelez ban_loginOk(), sinon appelez ban_loginFailed()
	La lib s'occupe de compter le nombre d'checs et de grer la dure de bannissement (bannissement/leve de ban).
	Cette lib cr un sous-rpertoire "data" qui contient les donnes de bannissement (ipbans.php) et un log de connexion (log.txt).
	*/
	date_default_timezone_set('Europe/Paris');
	$GLOBALS['config']['DATADIR'] = 'data'; // Data subdirectory
	$GLOBALS['config']['IPBANS_FILENAME'] = $GLOBALS['config']['DATADIR'].'/ipbans.php'; // File storage for failures and bans.
	$GLOBALS['config']['BAN_AFTER'] = 5; // Ban IP after this many failures.
	$GLOBALS['config']['BAN_DURATION'] = 600; // Ban duration for IP address after login failures (in seconds) (600 sec. = 10 minutes)
	if (!is_dir($GLOBALS['config']['DATADIR'])) { mkdir($GLOBALS['config']['DATADIR'],0705); chmod($GLOBALS['config']['DATADIR'],0705); }
	if (!is_file($GLOBALS['config']['DATADIR'].'/.htaccess')) { file_put_contents($GLOBALS['config']['DATADIR'].'/.htaccess',"Allow from none\nDeny from all\n"); } // Protect data files.

	function logm($message){
		$t = strval(date('Y/m/d_H:i:s')).' - '.$_SERVER["REMOTE_ADDR"].' - '.strval($message)."\n";
		file_put_contents($GLOBALS['config']['DATADIR'].'/log.txt',$t,FILE_APPEND);
	}

	// ------------------------------------------------------------------------------------------
	// Brute force protection system
	// Several consecutive failed logins will ban the IP address for 30 minutes.
	if (!is_file($GLOBALS['config']['IPBANS_FILENAME'])) file_put_contents($GLOBALS['config']['IPBANS_FILENAME'], "<?php\n\$GLOBALS['IPBANS']=".var_export(array('FAILURES'=>array(),'BANS'=>array()),true).";\n?>");
	include $GLOBALS['config']['IPBANS_FILENAME'];
	// Signal a failed login. Will ban the IP if too many failures:
	function ban_loginFailed()
	{
		$ip=$_SERVER["REMOTE_ADDR"]; $gb=$GLOBALS['IPBANS'];
		if (!isset($gb['FAILURES'][$ip])) $gb['FAILURES'][$ip]=0;
		$gb['FAILURES'][$ip]++;
		if ($gb['FAILURES'][$ip]>($GLOBALS['config']['BAN_AFTER']-1))
		{
			$gb['BANS'][$ip]=time()+$GLOBALS['config']['BAN_DURATION'];
			logm('IP address banned from login');
		}
		$GLOBALS['IPBANS'] = $gb;
		file_put_contents($GLOBALS['config']['IPBANS_FILENAME'], "<?php\n\$GLOBALS['IPBANS']=".var_export($gb,true).";\n?>");
	}

	// Signals a successful login. Resets failed login counter.
	function ban_loginOk(){
		$ip=$_SERVER["REMOTE_ADDR"]; $gb=$GLOBALS['IPBANS'];
		unset($gb['FAILURES'][$ip]); unset($gb['BANS'][$ip]);
		$GLOBALS['IPBANS'] = $gb;
		file_put_contents($GLOBALS['config']['IPBANS_FILENAME'], "<?php\n\$GLOBALS['IPBANS']=".var_export($gb,true).";\n?>");
		logm('Login ok.');
	}

	// Checks if the user CAN login. If 'true', the user can try to login.
	function ban_canLogin(){
		$ip=$_SERVER["REMOTE_ADDR"]; $gb=$GLOBALS['IPBANS'];
		if (isset($gb['BANS'][$ip]))
		{
			// User is banned. Check if the ban has expired:
			if ($gb['BANS'][$ip]<=time())
			{ // Ban expired, user can try to login again.
				logm('Ban lifted.');
				unset($gb['FAILURES'][$ip]); unset($gb['BANS'][$ip]);
				file_put_contents($GLOBALS['config']['IPBANS_FILENAME'], "<?php\n\$GLOBALS['IPBANS']=".var_export($gb,true).";\n?>");
				return true; // Ban has expired, user can login.
			}
			return false; // User is banned.
		}
		return true; // User is not banned.
	}
	
	//------------------------------------------
	//DEFAULT LOGIN TEXT
	//------------------------------------------
	//premire utilisation = texte installation
	if(ISSET($_SESSION["install_cfg"])){
		$login_msg_title = $GLOBALS['TRANSLATION']["install_viniviewer"];
		$login_msg = $GLOBALS['TRANSLATION']["install_txt"];
		$error_msg = "";
	}
	//textes par defaut pour la page
	else{
		$login_msg_title = $GLOBALS['TRANSLATION']["admin_panel_con"];
		$login_msg = $GLOBALS['TRANSLATION']["identification"];
		$error_msg = "";
	}
	
	//si l'utilisateur est identifi.
	if(ISSET($_SESSION["user_logged"])){
		header('Location: admin.php');
	}
	//si on envoi login+mdp pour identification
	elseif (isset($_POST['login']) && isset($_POST['password'])){
		//l'utilisateur n'a pas saisi de login ou de mot de passe
		if ($_POST['login'] == "" || $_POST['password'] == ""){
			$error_msg = $GLOBALS['TRANSLATION']["need_user_n_password"];
		}
		//test de l'identification
		else{
			//------------------------------------
			//premire utilisation = installation
			//------------------------------------
			if(ISSET($_SESSION["install_cfg"])){
			
				//on rcupre login et password
				extract($_POST);
				$login = htmlspecialchars($login);
				$password = htmlspecialchars($password);
				
				//on gnre un hash
				$salt = sha1(mt_rand());
				$hash_user = sha1($password.$login.$salt);
				
				//users parameters
				$CONFIG["thb_rdy"] = false;
				$CONFIG["salt"] = $salt;
				$CONFIG["login_user"] = $login;
				$CONFIG["hash_user"] = $hash_user;
				//load default settings
				$CONFIG["gal_name"] = $GLOBALS['PARAMETERS']['gal_name'];
				$CONFIG["language"] = $GLOBALS['PARAMETERS']['language'];
			
				$text = "<?php\n\$CONFIG=".var_export($CONFIG,true).";\n?>";
				
				//on enregistre les infos dans le fichier config
				file_put_contents($config_file, $text);
				
				//l'utilisateur est identifi
				$_SESSION["user_logged"] = true;
				//cfg est cr, on detruit le traceur
				unset($_SESSION["install_cfg"]);
				header('Location: admin.php');
			}
			elseif (ban_canLogin()==false){
				//l'utilisateur est banni
				$tban = $GLOBALS['config']['BAN_DURATION'] /60;
				$error_msg = $GLOBALS['TRANSLATION']["ban_2_many_try"];
				//on spcifie le temps de bannissement dans le message
				$error_msg = str_replace("{tban}", $tban, $error_msg);
			}
			elseif (ban_canLogin()==true){
				//l'utilisateur n'est pas banni, on teste le mot de passe
				extract($_POST);
				$login = htmlspecialchars($login);
				$password = htmlspecialchars($password);
				$hash = sha1($password.$login.$CONFIG["salt"]);	
				
				//on test le hash de l'utilisateur
				if($login==$CONFIG["login_user"] && $hash==$CONFIG["hash_user"]){
					//utilisateur identifi
					ban_loginOk();
					$_SESSION["user_logged"] = true;
					header('Location: admin.php');
				}
				else{
					//erreur de login/mot de passe. On enregistre la tentative
					ban_loginFailed();
					
					//on enregistre le message d'erreur
					$error_msg = $GLOBALS['TRANSLATION']["err_user_or_password"];
				}
			}
		}
	}
	
	//CHECK PHP FUNCTIONS
	function check_php_fct(){
		$install = false;
		$php = false;
		$exif = false;
		$gd = false;
		if (version_compare(phpversion(), "5.2.0", '>=')) $php = true;
		if (function_exists('exif_read_data')) $exif = true;
		if (extension_loaded('gd') && function_exists('gd_info')) $gd = true;
		
		if($php == true && $exif == true && $gd == true) $install = true;
		return array ($install, $php, $exif, $gd);
	}
	
	
	//check all required php functions are available
	$return = check_php_fct();
	if ($return[0] == false){
		$msg = "{err_php_function}";
		$msg .= "<ul style='text-align:left;margin-left:35px'>";
		//if php version is to low
		if($return[1] == false){
			$msg .= "<li>{php_version_not_comp}</li>";
		}
		//if functions are missing
		else{
			if($return[2] == false){
				$msg .= "
				<li style='margin-top:10px'>
					{exif_error}
					<ol>
						<li>extension=php_mbstring.dll</li>
						<li>extension=php_exif.dll</li>
					</ol>
				</li>";
			}
			if($return[3] == false){
				$msg .= "<li style='margin-top:10px'>{GD_error}</li>";
			}
		}
		$msg .= "<ul>";
		
		$_SESSION["message_title"] = $GLOBALS['TRANSLATION']["install_viniviewer"];
		$_SESSION["message"] = $msg;
		$_SESSION["message_btn"] = "";
		header('Location: message.php');
	}
	
	//---------------------------
	//display login page
	//---------------------------
	$login_page = file_get_contents('themes/default/templates/login.htm');
	$country_code = list_lang();
	
	//variables to add in the translation
	$COMP = array(
		"{login_msg_title}" => $login_msg_title, 
		"{login_msg}" => $login_msg,
		"{error_msg}" => $error_msg,
		"{country_code}" => $country_code
	);
	echo translate($login_page, $COMP);	

?>