<?php
// Copyright (c) 2013 Vincent SENE
// http://www.vincent-sene.com/viniviewer/
// Licence: http://www.opensource.org/licenses/zlib-license.php

	//intgration du fichier d'initialisation
	include_once('init_data.php');

	//opening json file
	read_json();
	
	//fonction creating the thumb list to display
	function generate_thb_list() {
		
		//on rcupre les variables globales
		global $images, $folder_images, $folder_thumbnails;
		
		//code contenant la galerie		
		$code = "\n";
		
		$id = 0;
		foreach($images as $key => $obj_img){
			//if image is not hidden
			if($obj_img->hide == false){
				$img = $obj_img->filename;
				//on rcupre le chemin de l'image
				$img_url = $obj_img->path();
				$thb_url = "$folder_thumbnails/".$img;
				$title = $img;
				
				//test if files are present
				if(!file_exists($img_url)){
					$img_url = "themes/default/images/thb_lost.png";
				}
				if(!file_exists($thb_url)){
					$thb_url = "themes/default/images/thb_lost.png";
				}
				
				$code .= "thb_url[$id] = '$thb_url';";
				$id++;
			}
		}
		return $code;
	}

	//fonction creating the folder list to display
	function generate_folder_list() {
		global $folders;
		
		$id = 0;
		foreach($folders as $key => $obj_folder){
			//if image is not hidden
			if($obj_folder->hide == false){
				$folder = $obj_folder->foldername;
				//on rcupre le chemin du dossier
				$folder_url = $obj_folder->folderpath();
				
				$code .= "folder_url[$id] = '$folder_url';";
				$code .= "folder_name[$id] = '$folder';";
				$id++;
			}
		}
		return $code;
	}
		
	
	//count the number of hidden images
	function nb_hidden_img(){
		global $images;
		
		$i = 0;
		foreach($images as $key => $obj_img){
			if($obj_img->hide == true){$i++;}
		}
		return $i;
	}
	
	//generate the javascript to include into template page
	function generate_javascript(){
		global $images, $first_img, $nb_img;
		
		$java_code = "
			var firstImg = $first_img,
			nb_img = $nb_img,
			w = new Array(),
			h = new Array(),
			thb_url = new Array(),
			folder_url = new Array(),
			folder_name = new Array(),
			pos = new Array(),
			com = new Array(),
			url = new Array(),
			exif = new Array();
		";
		//variables pour la position des miniatures lorsqu'il y a plusieurs pages
		$java_code .= "var delay_diapo = {$GLOBALS['PARAMETERS']['delay_diapo']};";
				
		//if admin authorize exif display
		if($GLOBALS['PARAMETERS']['allow_exif'] == true){
			//add exif term translation
			$exif_attrib = "Make Model DateTimeOriginal ExposureTime ISOSpeedRatings FocalLength FocalLengthIn35mmFilm FNumber LensModel Software";
				
			$java_code .= "\nvar exif_attrib = '$exif_attrib';";
			
			//create translation for each exif attrib
			$java_code .= "var exif_trad = new Array();";
			$tab = explode(" ", $exif_attrib);
			foreach($tab as $key =>$attrib){
				$java_code .= "exif_trad['$attrib'] = '".$GLOBALS['TRANSLATION'][$attrib]."';";
			}
		}
		//exif not allowed
		else{$java_code .= "\nvar exif_attrib = '';";}
		
		//data for each img
		$id = 0;
		foreach($images as $i => $obj_img){
			//if image is not hidden
			if($obj_img->hide == false){
				$width = $obj_img->width;
				$height = $obj_img->height;
				$com = $obj_img->text_out('java','nl2br');
				$img_url = $obj_img->path();
				$java_code .= "w[$id]=$width; h[$id]=$height; com[$id]= $com; url[$id] = '$img_url';";
				
				//ajout des infos exif
				$java_code .= "exif['$id'] = new Array();";
				foreach($obj_img->exif as $name => $value){
					if($value != ""){
						$java_code .= "exif['$id']['$name'] = '$value';";
					}
				}
				$id++;
			}
		}
		
		//code for all thumbnail images
		$java_code .= generate_thb_list();
		//code for folder
		$java_code .= generate_folder_list();
		
		return $java_code;
	}

	//get id of first photo to display
	if(ISSET($_GET['id'])){

		$id = htmlentities(intval($_GET['id']));
		if(array_key_exists($id, $images)){
			$first_img = $id;
		}
		else{
			$first_img = 0;
		}
	}
	else{
		$first_img = 0;
	}


	//---------------------------
	//display viewer page
	//---------------------------
	$nb_img = count($images)-nb_hidden_img();

	//get template page
	$viewer_page = file_get_contents('themes/'.$GLOBALS['PARAMETERS']['theme'].'/templates/viewer.htm');
	
	//generate javascript to include into page
	$java_code = generate_javascript();

	//generate the code to display thb
	$generate_gallery = generate_thb_list();
	
	//variables to add in the translation
	$gal_name = $GLOBALS['PARAMETERS']['gal_name'];
	$COMP = array(
		"{gal_name}" => $gal_name, 
		"{nb_img}" => $nb_img, 
		"{generate_gallery}" => $generate_gallery,
		"{viniviewer_version}" => $viniviewer_version,
		"{java_code}" => $java_code
	);
	echo translate($viewer_page, $COMP);

?>